import requests

url = "https://data.cityofnewyork.us/resource/43nn-pn8j.json"
params = f"critical_flag=Critical&$limit=500000"
full_url = f"{url}?{params}"

try:
    print(f"Sending GET request to {full_url} ...")

    response = requests.get(url, params=params)
    response.raise_for_status()
    
    restaurants = response.json()
    print(f"Number of critical restaurants: {len(restaurants)}")

except Exception as err:
    print(f"Error occurred: {err}")